# 프로세스 주소 공간

[프로세스](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Operating%20System/프로세스%20&%20스레드.md)는 자원을 할당받아 프로그램이 실행되고 있는 프로그램 인스턴스이다. 프로세스는 독립된 메모리 영역을 할당받고, 효율적으로 사용할 수 있도록 구조화하여 관리한다. 할당된 메모리 영역은 아래와 같이 `Code`, `Data`, `Heap`, `Stack` 영역으로 구분된다.   

프로세스가 실행 중 접근할 수 있도록 허용된 주소의 최대 범위를 **프로세스 주소 공간**이라고 하며, 프로세스의 주소 공간은 CPU 주소 공간*과 같다.  

_\*CPU 주소 공간: 컴퓨터 내에 CPU가 접근 가능한 전체 메모리 공간, CPU의 주소선 개수에 따라 크기가 결정된다. 32비트 CPU는 주소선이 32개로 CPU 주소 공간의 크기는 `2^32Byte` = `4GB`이다._  

<img src="https://velog.velcdn.com/images/turningtwenty/post/01a56f68-c32c-4942-a7ef-8840d087215b/image.png" alt="ProcessAddressSpace" width="500px" />
<br/>

## 프로세스 주소 공간 구조
프로세스 주소 공간은 사용자 공간과 커널 공간 전체를 포함한다.  

프로세스의 크기와 프로세스 주소 공간 크기는 다르다. 프로세스 주소 공간 크기는 프로세스가 액세스 할 수 있는(=커져 갈 수 있는) 전체 영역을 뜻하지만, 프로세스의 크기는 프로세스가 주소 공간 내에서 현재 사용하고 있는 코드, 데이터, 힙, 스택을 합친 크기를 뜻한다.  

프로세스의 주소 공간에서 힙과 스택 영역의 크기는 정해져 있지 않고, 코드와 데이터를 뺀 나머지 공간을 둘이 합쳐 사용한다. 프로세스의 주소 공간에서 힙은 데이터 영역이 끝난 영역에서 시작하여 주소가 큰 쪽으로 커지고, 스택은 사용자 주소 공간의 끝에서 주소가 작은 쪽으로 커진다.  

결론적으로, 프로세스는 운영체제에서 설정한 사용자 공간의 최대 범위까지 힙 영역과 스택 영역을 늘려갈 수 있다. 뿐만 아니라, 시스템 호출을 통해 커널 공간까지 접근 할 수 있으므로, 사용자 공간과 커널 공간을 합쳐 CPU가 액세스 할 수 있는 전체 공간이 프로세스의 주소 공간이다.  

<br>

### 프로세스의 구성

<img src="https://user-images.githubusercontent.com/66757141/210362098-35866087-0562-4e19-b0cc-2b8dc9a112c9.gif" alt="procmem" width="400px" />  

_[UNIX: PROCESS ADDRESS SPACE LAYOUT](https://oneszeroesbits.wordpress.com/2015/09/26/unix-process-address-space-layout/)_  

- **코드(Code) 영역**
  텍스트 영역이라고도 한다.  
  실행 파일 내에 구성된 코드들이 적재되는 영역으로, 프로그램을 실행시키기 위한 구성인 명령문들이 저장된다. `제어문`, `함수`, `상수`들이 포함된다.  
  CPU가 해석 가능한 기계어로 저장되고, 프로그램이 수정되면 안 되므로 `ReadOnly` 상태로 저장 되어있다.

- **데이터(Data) 영역**
  실행 파일 내에 구성된 전역 변수들이 적재되는 영역으로, 코드의 전역변수, 정적변수 등이 저장되는 공간이다. 
  Stack에 저장되는 변수들과 비교하면 main 함수가 실행되는 동안 메모리 상에 남아있는 변수들을 저장한다는 차이점이 있다.  
  데이터 영역은 크게 `초기화된 데이터 영역(initialized data segment)`과 `초기화되지 않은 데이터 영역(uninitialized data segment)`로 나뉜다.

- **힙(Heap) 영역**
  프로세스의 실행중 동적으로 할당 및 해제되는, 동적 메모리 할당 영역이다. 따라서 런타임에 크기가 결정된다. 언어마다 차이가 있지만 주로 참조형 데이터(Class 등)의 데이터가 할당된다.  
  낮은 주소에서 높은 주소로 적재된다.  
  Heap 메모리 영역을 넘어서 할당하면 `Heap Overflow`가 발생한다.

- **스택(Stack) 영역**
  프로세스의 실행 시 사용되는 영역으로, 함수 호출시 매개변수들과 전역 변수 등을 저장한다. 함수가 종료되면 해당 함수에 의해 할당된 변수들은 메모리에서 해제된다.  
  높은 주소에서 낮은 주소로 할당된다.  
  Stack 메모리 영역을 넘어서 할당하면 `Stack Overflow`가 발생한다.

<br/>

각 영역은 저장하는 데이터의 특성에 따라 효율적으로 관리하기 위해 구분되었음을 알 수 있다.

**Code 영역** 의 경우 변경되지 않는 기계어 코드를 Read-Only 상태로 저장해야한다.

**Data 영역** 과 **Stack 영역** 을 구분한 이유는, Data 영역에 전역변수의 자원을 따로 저장하고 Thread들이 공유하도록 하여 효율성을 높이고, 함수와 지역 변수 등은 각 스레드마다 공간을 할당한 Stack 구조로, 사용이 종료됨에 따라 해제하는 등의 제어에 용이하다.

<br/>

프로세스는 `Code`, `Data`, `Heap`, `Stack`의 메모리 영역을 독립적으로 할당받지만, 그에 속해있는 스레드는 Stack만을 각각 할당받고, 다른 영역은 공유한다고 했다. 
[프로세스 &  스레드 자세히 보기](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Operating%20System/프로세스%20&%20스레드.md)  

이를 그림으로 살펴보면 아래와 같다.  

<img src="https://user-images.githubusercontent.com/66757141/210360710-7ce59dc1-18f7-4c1e-baf1-c0d4a0d87c4a.png" alt="Figure 26.1: Single-Threaded And Multi-Threaded Address Spaces" width="500px" />

<br/>

---

## Reference
📄https://st-lab.tistory.com/198 (실제 메모리에 저장된 내용을 디버깅하며 자세하게 설명되어있다.)  
📄https://velog.io/@klm03025/운영체제-프로세스-주소-공간  
📄https://oneszeroesbits.wordpress.com/2015/09/26/unix-process-address-space-layout/  
📄https://velog.io/@turningtwenty/운영체제Operating-System-프로세스와-프로세스-관리